/*
 * Decompiled with CFR 0.152.
 */
package Datch.util;

import java.awt.Component;
import java.awt.Container;
import javax.swing.Spring;
import javax.swing.SpringLayout;

public class SpringUtilities {
    private static boolean isDebugEnabled() {
        try {
            return Boolean.parseBoolean(System.getProperty("Datch.debug.from.args", "false"));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void printSizes(Component component) {
        if (SpringUtilities.isDebugEnabled()) {
            System.out.println("minimumSize = " + String.valueOf(component.getMinimumSize()));
            System.out.println("preferredSize = " + String.valueOf(component.getPreferredSize()));
            System.out.println("maximumSize = " + String.valueOf(component.getMaximumSize()));
        }
    }

    public static void makeGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        block9: {
            try {
                SpringLayout.Constraints constraints;
                int i;
                SpringLayout layout = (SpringLayout)parent.getLayout();
                Spring xPadSpring = Spring.constant(xPad);
                Spring yPadSpring = Spring.constant(yPad);
                Spring initialXSpring = Spring.constant(initialX);
                Spring initialYSpring = Spring.constant(initialY);
                int totalComponents = rows * cols;
                Spring maxWidthSpring = layout.getConstraints(parent.getComponent(0)).getWidth();
                Spring maxHeightSpring = layout.getConstraints(parent.getComponent(0)).getHeight();
                for (i = 1; i < totalComponents; ++i) {
                    constraints = layout.getConstraints(parent.getComponent(i));
                    maxWidthSpring = Spring.max(maxWidthSpring, constraints.getWidth());
                    maxHeightSpring = Spring.max(maxHeightSpring, constraints.getHeight());
                }
                for (i = 0; i < totalComponents; ++i) {
                    constraints = layout.getConstraints(parent.getComponent(i));
                    constraints.setWidth(maxWidthSpring);
                    constraints.setHeight(maxHeightSpring);
                }
                SpringLayout.Constraints lastConstraints = null;
                SpringLayout.Constraints lastRowConstraints = null;
                for (int i2 = 0; i2 < totalComponents; ++i2) {
                    SpringLayout.Constraints constraints2 = layout.getConstraints(parent.getComponent(i2));
                    if (i2 % cols == 0) {
                        lastRowConstraints = lastConstraints;
                        constraints2.setX(initialXSpring);
                    } else {
                        constraints2.setX(Spring.sum(lastConstraints.getConstraint("East"), xPadSpring));
                    }
                    if (i2 / cols == 0) {
                        constraints2.setY(initialYSpring);
                    } else {
                        constraints2.setY(Spring.sum(lastRowConstraints.getConstraint("South"), yPadSpring));
                    }
                    lastConstraints = constraints2;
                }
                SpringLayout.Constraints parentConstraints = layout.getConstraints(parent);
                parentConstraints.setConstraint("South", Spring.sum(Spring.constant(yPad), lastConstraints.getConstraint("South")));
                parentConstraints.setConstraint("East", Spring.sum(Spring.constant(xPad), lastConstraints.getConstraint("East")));
            }
            catch (ClassCastException castException) {
                if (!SpringUtilities.isDebugEnabled()) break block9;
                System.err.println("The first argument to makeGrid must use SpringLayout.");
            }
        }
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component component = parent.getComponent(row * cols + col);
        return layout.getConstraints(component);
    }

    public static void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        block8: {
            try {
                SpringLayout layout = (SpringLayout)parent.getLayout();
                Spring xPosition = Spring.constant(initialX);
                for (int col = 0; col < cols; ++col) {
                    int row;
                    Spring width = Spring.constant(0);
                    for (row = 0; row < rows; ++row) {
                        width = Spring.max(width, SpringUtilities.getConstraintsForCell(row, col, parent, cols).getWidth());
                    }
                    for (row = 0; row < rows; ++row) {
                        SpringLayout.Constraints constraints = SpringUtilities.getConstraintsForCell(row, col, parent, cols);
                        constraints.setX(xPosition);
                        constraints.setWidth(width);
                    }
                    xPosition = Spring.sum(xPosition, Spring.sum(width, Spring.constant(xPad)));
                }
                Spring yPosition = Spring.constant(initialY);
                for (int row = 0; row < rows; ++row) {
                    int col;
                    Spring height = Spring.constant(0);
                    for (col = 0; col < cols; ++col) {
                        height = Spring.max(height, SpringUtilities.getConstraintsForCell(row, col, parent, cols).getHeight());
                    }
                    for (col = 0; col < cols; ++col) {
                        SpringLayout.Constraints constraints = SpringUtilities.getConstraintsForCell(row, col, parent, cols);
                        constraints.setY(yPosition);
                        constraints.setHeight(height);
                    }
                    yPosition = Spring.sum(yPosition, Spring.sum(height, Spring.constant(yPad)));
                }
                SpringLayout.Constraints parentConstraints = layout.getConstraints(parent);
                parentConstraints.setConstraint("South", yPosition);
                parentConstraints.setConstraint("East", xPosition);
            }
            catch (ClassCastException castException) {
                if (!SpringUtilities.isDebugEnabled()) break block8;
                System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            }
        }
    }
}

