/*
 * Decompiled with CFR 0.152.
 */
package Datch.util;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class Keygen {
    private static final byte[] ENCRYPTION_KEY = "burpr0x!".getBytes();
    public static final String STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    public static final String ALGORITHM = "DES";

    public static String generateLicense(String licenseName) {
        ArrayList<String> licenseArray = new ArrayList<String>();
        licenseArray.add(Keygen.getRandomString());
        licenseArray.add("license");
        licenseArray.add(licenseName);
        licenseArray.add("4102415999000");
        licenseArray.add("1");
        licenseArray.add("full");
        licenseArray.add(" ignore SHA256withRSA");
        licenseArray.add(" ignore SHA1withRSA");
        return Keygen.prepareArray(licenseArray);
    }

    public static List<String> decodeActivationRequest(String activationRequest) {
        try {
            List<String> decodedRequest = Keygen.getParamsList(activationRequest);
            if (decodedRequest.size() != 5) {
                System.out.print("\u6fc0\u6d3b\u8bf7\u6c42\u89e3\u7801\u540e\u5927\u5c0f\u9519\u8bef\uff01\u89e3\u7801\u5185\u5bb9\u5982\u4e0b\uff1a \n" + String.valueOf(decodedRequest));
                return null;
            }
            return decodedRequest;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String generateActivation(String activationRequest) {
        List<String> request = Keygen.decodeActivationRequest(activationRequest);
        if (request == null) {
            return "\u6fc0\u6d3b\u8bf7\u6c42\u4e0d\u6b63\u786e";
        }
        ArrayList<String> responseArray = new ArrayList<String>();
        responseArray.add("0.4315672535134567");
        responseArray.add(request.get(0));
        responseArray.add("activation");
        responseArray.add(request.get(1));
        responseArray.add("True");
        responseArray.add("");
        responseArray.add(request.get(2));
        responseArray.add(request.get(3));
        responseArray.add(" ignore SHA256withRSA");
        responseArray.add(" ignore SHA1withRSA");
        return Keygen.prepareArray(responseArray);
    }

    public static void rewriteBytes(Object[] objectArray) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        byte[] data = (byte[])objectArray[0];
        byte[] decodedData = Base64.getDecoder().decode(data);
        byte[] decryptedData = Keygen.decrypt(decodedData);
        String decryptedString = new String(decryptedData);
        String[] parts = decryptedString.split("\u0000");
        objectArray[0] = Arrays.copyOf(parts, parts.length - 2);
    }

    private static byte[] encrypt(byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(ENCRYPTION_KEY, ALGORITHM);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, secretKeySpec);
            return cipher.doFinal(data);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    private static byte[] decrypt(byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(ENCRYPTION_KEY, ALGORITHM);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, secretKeySpec);
            return cipher.doFinal(data);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    private static List<String> getParamsList(String encodedData) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        byte[] rawBytes = Keygen.decrypt(Base64.getDecoder().decode(encodedData));
        ArrayList<String> paramsList = new ArrayList<String>();
        int startIndex = 0;
        for (int i = 0; i < rawBytes.length; ++i) {
            if (rawBytes[i] != 0) continue;
            paramsList.add(new String(rawBytes, startIndex, i - startIndex));
            startIndex = i + 1;
        }
        paramsList.add(new String(rawBytes, startIndex, rawBytes.length - startIndex));
        return paramsList;
    }

    private static String getRandomString() {
        StringBuilder randomString = new StringBuilder();
        Random random = new Random();
        while (randomString.length() < 32) {
            int index = random.nextInt(STRING.length());
            randomString.append(STRING.charAt(index));
        }
        return randomString.toString();
    }

    private static String prepareArray(List<String> dataList) {
        try {
            ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
            for (int i = 0; i < dataList.size() - 1; ++i) {
                byteArrayStream.write(dataList.get(i).getBytes());
                byteArrayStream.write(0);
            }
            byteArrayStream.write(dataList.get(dataList.size() - 1).getBytes());
            return new String(Base64.getEncoder().encode(Keygen.encrypt(byteArrayStream.toByteArray())));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }
}

