/*
 * Decompiled with CFR 0.152.
 */
package Datch.util;

import Datch.KeygenDialog;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.prefs.Preferences;

public class CommonUtil {
    public static final String NOT_FOUND_JAR = "burpsuite_jar_not_found.jar";
    public static String currentDir;
    public static String burpJarName;
    public static String LOADER_JAR_NAME;
    public static final String KEY_AUTO_START = "auto start";
    public static final String KEY_LOADER = "loader";
    public static final String KEY_HANZIFY = "hanizfy";
    public static final String KEY_DEBUG = "debug";
    public static final String KEY_EDIT_LOADER = "edit loader";
    public static final String KEY_EDIT_LICENSE = "edit license";
    private static final Executor LOG_EXECUTOR;
    static Toolkit toolkit;
    static Clipboard clipboard;
    public static final Preferences PREFERENCES;

    private static String initLoaderJarName() {
        try {
            File jarFile = new File(KeygenDialog.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            if (jarFile.isFile() && jarFile.getName().endsWith(".jar")) {
                return jarFile.getName();
            }
            String directory = jarFile.isDirectory() ? jarFile.getPath() : jarFile.getParent();
            String foundJar = CommonUtil.getNewestFile(directory, "*.jar");
            if (!foundJar.isEmpty()) {
                return foundJar;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    public static String getLaunchCommand() throws NumberFormatException {
        boolean useLoader = PREFERENCES.getBoolean(KEY_LOADER, true);
        boolean useHanzify = PREFERENCES.getBoolean(KEY_HANZIFY, true);
        boolean useDebug = PREFERENCES.getBoolean(KEY_DEBUG, false);
        return CommonUtil.getLaunchCommand(useLoader, useHanzify, useDebug);
    }

    public static String getLaunchCommand(boolean useLoader, boolean useHanzify, boolean useDebug) throws NumberFormatException {
        int javaVersion;
        StringBuilder command = new StringBuilder();
        File jreDirectory = new File(currentDir, "jre" + File.separator + "bin");
        if (jreDirectory.exists()) {
            command.append(jreDirectory.getAbsolutePath()).append(File.separator);
        } else {
            File binDirectory = new File(currentDir, "bin");
            if (binDirectory.exists()) {
                command.append(binDirectory.getAbsolutePath()).append(File.separator);
            }
        }
        command.append("java").append(" -XX:+UseG1GC -XX:+UseStringDeduplication -XX:MaxGCPauseMillis=200 -XX:+IgnoreUnrecognizedVMOptions -XX:MaxRAMPercentage=50");
        String currentJarName = "";
        try {
            File jarFile = new File(KeygenDialog.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            currentJarName = jarFile.isFile() && jarFile.getName().endsWith(".jar") ? jarFile.getName() : LOADER_JAR_NAME;
        }
        catch (Exception exception) {
            currentJarName = LOADER_JAR_NAME;
        }
        if (!currentJarName.isEmpty()) {
            command.append(" -javaagent:").append(currentJarName);
            StringBuilder agentArgs = new StringBuilder();
            if (useLoader) {
                agentArgs.append(KEY_LOADER);
            }
            if (useHanzify) {
                if (agentArgs.length() > 0) {
                    agentArgs.append(",");
                }
                agentArgs.append(KEY_HANZIFY);
            }
            if (useDebug) {
                if (agentArgs.length() > 0) {
                    agentArgs.append(",");
                }
                agentArgs.append(KEY_DEBUG);
            }
            if (agentArgs.length() > 0) {
                command.append("=").append((CharSequence)agentArgs);
            } else {
                command.append("=none");
            }
        }
        if ((javaVersion = Integer.parseInt(System.getProperty("java.version", "8").split("\\.")[0])) < 11) {
            command.delete(0, command.length() - 1).append("upgrade jdk to 11+!!!");
        } else if (javaVersion >= 11) {
            command.append(" --add-opens=java.desktop/javax.swing=ALL-UNNAMED");
            command.append(" --add-opens=java.base/java.lang=ALL-UNNAMED");
            command.append(" --add-opens=java.base/jdk.internal.org.objectweb.asm=ALL-UNNAMED");
            command.append(" --add-opens=java.base/jdk.internal.org.objectweb.asm.tree=ALL-UNNAMED");
            command.append(" --add-opens=java.base/jdk.internal.org.objectweb.asm.Opcodes=ALL-UNNAMED");
            command.append(" -Dfile.encoding=UTF-8");
            if (javaVersion < 13) {
                command.append(" -noverify");
            }
            if (javaVersion == 16) {
                command.append(" --illegal-access=permit");
            }
            if (javaVersion >= 16) {
                command.append(" --enable-native-access=ALL-UNNAMED");
            }
            command.append(" -jar ").append(burpJarName);
        }
        return command.toString();
    }

    public static String getNewestFile(String directory, String globPattern) throws IOException {
        long lastModifiedTime = 0L;
        String newestFileName = "";
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(directory, new String[0]), globPattern);){
            for (Path filePath : directoryStream) {
                if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS) || lastModifiedTime >= filePath.toFile().lastModified()) continue;
                lastModifiedTime = filePath.toFile().lastModified();
                newestFileName = filePath.getFileName().toString();
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        return newestFileName;
    }

    public static boolean hasBurpJar() {
        return !NOT_FOUND_JAR.equals(burpJarName) && !LOADER_JAR_NAME.isEmpty();
    }

    public static void copy(String text) {
        clipboard.setContents(new StringSelection(text), null);
    }

    public static String pasteString() {
        Transferable transferable = clipboard.getContents(null);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static void executeCmd(String command) throws IOException {
        Thread launcherThread = new Thread(() -> {
            try {
                boolean debugMode = PREFERENCES.getBoolean(KEY_DEBUG, false);
                File logDirectory = new File(currentDir != null ? currentDir : ".", "log");
                if (debugMode) {
                    try {
                        if (!logDirectory.exists()) {
                            logDirectory.mkdirs();
                        }
                        FileWriter commandWriter = new FileWriter(new File(logDirectory, "last_run_cmd.txt"));
                        commandWriter.write(command);
                        commandWriter.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                File workingDirectory = new File(currentDir != null ? currentDir : ".");
                if (System.getProperty("os.name").toLowerCase().contains("win")) {
                    Process process = Runtime.getRuntime().exec(command, null, workingDirectory);
                    if (debugMode) {
                        File outputFile = new File(logDirectory, "burp_out.txt");
                        File errorFile = new File(logDirectory, "burp_err.txt");
                        new StreamGobbler(process.getInputStream(), outputFile).start();
                        new StreamGobbler(process.getErrorStream(), errorFile).start();
                    } else {
                        new Thread(() -> {
                            try (InputStream inputStream = process.getInputStream();){
                                byte[] buffer = new byte[1024];
                                while (inputStream.read(buffer) != -1) {
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }).start();
                        new Thread(() -> {
                            try (InputStream errorStream = process.getErrorStream();){
                                byte[] buffer = new byte[1024];
                                while (errorStream.read(buffer) != -1) {
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }).start();
                    }
                } else {
                    Process process;
                    if (debugMode) {
                        String outputPath = new File(logDirectory, "burp_out.txt").getAbsolutePath();
                        String errorPath = new File(logDirectory, "burp_err.txt").getAbsolutePath();
                        String shellCommand = "cd \"" + workingDirectory.getAbsolutePath() + "\" && nohup " + command + " > \"" + outputPath + "\" 2> \"" + errorPath + "\" &";
                        ProcessBuilder processBuilder = new ProcessBuilder("sh", "-c", shellCommand);
                        process = processBuilder.start();
                    } else {
                        ProcessBuilder processBuilder = new ProcessBuilder("sh", "-c", "cd \"" + workingDirectory.getAbsolutePath() + "\" && nohup " + command + " > /dev/null 2>&1 &");
                        process = processBuilder.start();
                    }
                    process.getInputStream().close();
                    process.getErrorStream().close();
                    process.getOutputStream().close();
                }
            }
            catch (IOException ioException) {
                System.err.println("\u542f\u52a8Burp\u9519\u8bef: " + ioException.getMessage());
                ioException.printStackTrace();
            }
        }, "BurpLauncher");
        launcherThread.setDaemon(true);
        launcherThread.start();
    }

    public static void writeFile(FileWriter fileWriter, String msg) {
        LOG_EXECUTOR.execute(() -> {
            try {
                fileWriter.write(msg);
                fileWriter.flush();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        });
    }

    static {
        LOG_EXECUTOR = Executors.newSingleThreadExecutor();
        toolkit = Toolkit.getDefaultToolkit();
        clipboard = toolkit.getSystemClipboard();
        PREFERENCES = Preferences.userNodeForPackage(KeygenDialog.class);
        currentDir = null;
        try {
            File jarFile = new File(KeygenDialog.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            currentDir = jarFile.isDirectory() ? jarFile.getPath() : jarFile.getParentFile().toString();
            System.out.println("\u5f53\u524d\u76ee\u5f55: " + currentDir);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        LOADER_JAR_NAME = CommonUtil.initLoaderJarName();
        try {
            burpJarName = CommonUtil.getNewestFile(currentDir, "burpsuite_*.jar");
        }
        catch (IOException ioException) {
            burpJarName = NOT_FOUND_JAR;
        }
        if (Objects.equals(burpJarName, "")) {
            burpJarName = NOT_FOUND_JAR;
        }
    }

    private static class StreamGobbler
    extends Thread {
        private final InputStream inputStream;
        private final File logFile;

        StreamGobbler(InputStream inputStream, File logFile) {
            this.inputStream = inputStream;
            this.logFile = logFile;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.logFile, true);
                 InputStream input = this.inputStream;){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = input.read(buffer)) != -1) {
                    fileOutputStream.write(buffer, 0, bytesRead);
                    fileOutputStream.flush();
                }
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
    }
}

