/*
 * Decompiled with CFR 0.152.
 */
package Datch.transformer;

import Datch.util.CommonUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TranslateTransformer
implements ClassFileTransformer {
    private static final Map<String, InjectionMethod> INJECTION_METHODS = new HashMap<String, InjectionMethod>(16);
    private static FileWriter errorLogWriter;
    private static boolean debugEnabled;

    public static void init(boolean debug) {
        debugEnabled = debug;
        if (debugEnabled) {
            File logDir = new File(CommonUtil.currentDir != null ? CommonUtil.currentDir : ".", "log");
            logDir.mkdirs();
            try {
                errorLogWriter = new FileWriter(new File(logDir, "transformer_error.txt"), true);
                errorLogWriter.write("[" + String.valueOf(new Date()) + "] TranslateTransformer\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u8c03\u8bd5\u6a21\u5f0f=" + debugEnabled + "\n");
                errorLogWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void log(String message) {
        if (debugEnabled && errorLogWriter != null) {
            try {
                errorLogWriter.write("[" + String.valueOf(new Date()) + "] " + message + "\n");
                errorLogWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void flushLogs() {
        if (errorLogWriter != null) {
            try {
                errorLogWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public byte[] transform(ClassLoader classLoader, String className, Class<?> cls, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        return this.transform(className, classfileBuffer);
    }

    private void hookMethod(ClassNode classNode, MethodNode method, int paramIndex) {
        block16: {
            try {
                boolean isStatic = (method.access & 8) != 0;
                boolean isConstructor = "<init>".equals(method.name);
                Type[] argTypes = Type.getArgumentTypes(method.desc);
                if (paramIndex < 1 || paramIndex > argTypes.length) {
                    if (debugEnabled) {
                        TranslateTransformer.log("\u53c2\u6570\u7d22\u5f15\u8d85\u51fa\u8303\u56f4: " + paramIndex + ", \u65b9\u6cd5\u53c2\u6570\u6570\u91cf: " + argTypes.length);
                    }
                    return;
                }
                int localVarIndex = isStatic ? 0 : 1;
                for (int i = 0; i < paramIndex - 1; ++i) {
                    localVarIndex += argTypes[i].getSize();
                }
                Type paramType = argTypes[paramIndex - 1];
                if (paramType.getSort() != 10 || !paramType.getInternalName().equals("java/lang/String")) {
                    if (debugEnabled) {
                        TranslateTransformer.log("\u53c2\u6570\u7c7b\u578b\u4e0d\u662f String: " + String.valueOf(paramType));
                    }
                    return;
                }
                InsnList newInstructions = new InsnList();
                LabelNode tryStart = new LabelNode();
                LabelNode tryEnd = new LabelNode();
                LabelNode handler = new LabelNode();
                LabelNode endLabel = new LabelNode();
                LabelNode ifNullLabel = new LabelNode();
                LabelNode ifNotStringLabel = new LabelNode();
                newInstructions.add(new VarInsnNode(25, localVarIndex));
                newInstructions.add(new InsnNode(89));
                newInstructions.add(new JumpInsnNode(198, ifNullLabel));
                newInstructions.add(new InsnNode(89));
                newInstructions.add(new TypeInsnNode(193, "java/lang/String"));
                newInstructions.add(new JumpInsnNode(153, ifNotStringLabel));
                newInstructions.add(new InsnNode(87));
                newInstructions.add(tryStart);
                newInstructions.add(new MethodInsnNode(184, "java/lang/ClassLoader", "getSystemClassLoader", "()Ljava/lang/ClassLoader;", false));
                newInstructions.add(new LdcInsnNode("Datch.Translator"));
                newInstructions.add(new MethodInsnNode(182, "java/lang/ClassLoader", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", false));
                newInstructions.add(new LdcInsnNode("translate"));
                if (isConstructor || isStatic) {
                    this.buildClassArray(newInstructions, 2, "Ljava/lang/String;", "Ljava/lang/String;");
                } else {
                    this.buildClassArray(newInstructions, 3, "Ljava/lang/Object;", "Ljava/lang/String;", "Ljava/lang/String;");
                }
                newInstructions.add(new MethodInsnNode(182, "java/lang/Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", false));
                if (isConstructor || isStatic) {
                    this.buildInvokeArgs(newInstructions, 2, null, "cn", localVarIndex);
                } else {
                    this.buildInvokeArgs(newInstructions, 3, 0, "cn", localVarIndex);
                }
                newInstructions.add(new MethodInsnNode(182, "java/lang/reflect/Method", "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", false));
                newInstructions.add(new TypeInsnNode(192, "java/lang/String"));
                newInstructions.add(new VarInsnNode(58, localVarIndex));
                newInstructions.add(tryEnd);
                newInstructions.add(new JumpInsnNode(167, endLabel));
                newInstructions.add(handler);
                newInstructions.add(new InsnNode(87));
                newInstructions.add(new JumpInsnNode(167, endLabel));
                newInstructions.add(ifNullLabel);
                newInstructions.add(new InsnNode(87));
                newInstructions.add(new JumpInsnNode(167, endLabel));
                newInstructions.add(ifNotStringLabel);
                newInstructions.add(new InsnNode(87));
                newInstructions.add(new JumpInsnNode(167, endLabel));
                newInstructions.add(endLabel);
                method.tryCatchBlocks.add(new TryCatchBlockNode(tryStart, tryEnd, handler, "java/lang/Exception"));
                if (method.instructions.size() > 0) {
                    AbstractInsnNode firstInsn = method.instructions.getFirst();
                    if (firstInsn instanceof LabelNode) {
                        method.instructions.insert(firstInsn, newInstructions);
                    } else {
                        method.instructions.insertBefore(firstInsn, newInstructions);
                    }
                } else {
                    LabelNode startLabel = new LabelNode();
                    method.instructions.add(startLabel);
                    method.instructions.add(newInstructions);
                }
                if (debugEnabled) {
                    TranslateTransformer.log("\u6210\u529f\u4e3a\u65b9\u6cd5 " + method.name + " \u7684\u7b2c " + paramIndex + " \u4e2a\u53c2\u6570\u6ce8\u5165\u7ffb\u8bd1\u4ee3\u7801\uff0c\u5c40\u90e8\u53d8\u91cf\u7d22\u5f15: " + localVarIndex);
                }
            }
            catch (Exception exception) {
                if (!debugEnabled) break block16;
                TranslateTransformer.log("\u9519\u8bef: Hook\u65b9\u6cd5\u5931\u8d25: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private void buildClassArray(InsnList instructions, int size, String ... typeDescriptors) {
        instructions.add(new InsnNode(size == 2 ? 5 : 6));
        instructions.add(new TypeInsnNode(189, "java/lang/Class"));
        for (int i = 0; i < size; ++i) {
            instructions.add(new InsnNode(89));
            instructions.add(new InsnNode(i == 0 ? 3 : (i == 1 ? 4 : 5)));
            instructions.add(new LdcInsnNode(Type.getType(typeDescriptors[i])));
            instructions.add(new InsnNode(83));
        }
    }

    private void buildInvokeArgs(InsnList instructions, int size, Integer thisIndex, String lang, int paramIndex) {
        instructions.add(new InsnNode(1));
        instructions.add(new InsnNode(size == 2 ? 5 : 6));
        instructions.add(new TypeInsnNode(189, "java/lang/Object"));
        if (thisIndex != null) {
            instructions.add(new InsnNode(89));
            instructions.add(new InsnNode(3));
            instructions.add(new VarInsnNode(25, thisIndex));
            instructions.add(new InsnNode(83));
        }
        instructions.add(new InsnNode(89));
        instructions.add(new InsnNode(thisIndex != null ? 4 : 3));
        instructions.add(new LdcInsnNode(lang));
        instructions.add(new InsnNode(83));
        instructions.add(new InsnNode(89));
        instructions.add(new InsnNode(thisIndex != null ? 5 : 4));
        instructions.add(new VarInsnNode(25, paramIndex));
        instructions.add(new InsnNode(83));
    }

    private byte[] transform(String className, byte[] classBytes) throws IllegalClassFormatException {
        if (!(className.startsWith("java/awt") || className.startsWith("javax/swing") || "java/lang/Class".equals(className) || className.startsWith("burp/"))) {
            return null;
        }
        try {
            if (debugEnabled) {
                TranslateTransformer.log("\u5f00\u59cb\u8f6c\u6362\u7c7b: " + className);
            }
            ClassReader classReader = new ClassReader(classBytes);
            ClassNode classNode = new ClassNode();
            classReader.accept(classNode, 0);
            InjectionMethod injectionMethod = INJECTION_METHODS.get(className);
            if (injectionMethod != null) {
                return this.processInjectionMethod(classNode, classReader, className, injectionMethod);
            }
            if ("javax/swing/JTabbedPane".equals(className)) {
                return this.processJTabbedPane(classNode, classReader);
            }
            if ("javax/swing/JDialog".equals(className)) {
                return this.processJDialog(classNode, classReader);
            }
            if ("java/lang/Class".equals(className)) {
                return this.processClass(classNode, classReader);
            }
            return null;
        }
        catch (Exception exception) {
            if (debugEnabled) {
                TranslateTransformer.log("\u9519\u8bef: \u8f6c\u6362 " + className + " \u65f6\u53d1\u751f\u5f02\u5e38: " + exception.getMessage());
            }
            return null;
        }
    }

    private byte[] processInjectionMethod(ClassNode classNode, ClassReader classReader, String className, InjectionMethod injectionMethod) {
        try {
            MethodNode targetMethod = this.findMethod(classNode, injectionMethod);
            if (targetMethod == null) {
                if (debugEnabled) {
                    TranslateTransformer.log("\u672a\u627e\u5230\u65b9\u6cd5: " + injectionMethod.methodName + " \u5728\u7c7b " + className);
                }
                return null;
            }
            if (debugEnabled) {
                TranslateTransformer.log("\u627e\u5230\u65b9\u6cd5: " + injectionMethod.methodName + " \u5728\u7c7b " + className + ", \u63cf\u8ff0\u7b26: " + targetMethod.desc);
            }
            this.hookMethod(classNode, targetMethod, injectionMethod.place);
            return this.buildClassBytes(classNode, classReader, className);
        }
        catch (Exception exception) {
            if (debugEnabled) {
                TranslateTransformer.log("\u9519\u8bef: \u6ce8\u5165 " + injectionMethod.methodName + " \u5230 " + className + " \u5931\u8d25: " + exception.getMessage());
                exception.printStackTrace();
            }
            return null;
        }
    }

    private MethodNode findMethod(ClassNode classNode, InjectionMethod injectionMethod) {
        if (debugEnabled) {
            TranslateTransformer.log("\u67e5\u627e\u65b9\u6cd5: " + injectionMethod.methodName + ", \u9700\u8981\u53c2\u6570\u4f4d\u7f6e: " + injectionMethod.place);
            TranslateTransformer.log("\u7c7b\u4e2d\u6240\u6709\u65b9\u6cd5\u6570\u91cf: " + classNode.methods.size());
        }
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(injectionMethod.methodName)) continue;
            Type[] argTypes = Type.getArgumentTypes(method.desc);
            if (debugEnabled) {
                TranslateTransformer.log("\u627e\u5230\u540c\u540d\u65b9\u6cd5: " + method.name + ", \u63cf\u8ff0\u7b26: " + method.desc + ", \u53c2\u6570\u6570\u91cf: " + argTypes.length);
            }
            if (argTypes.length < injectionMethod.place) continue;
            if (debugEnabled) {
                TranslateTransformer.log("\u5339\u914d\u5230\u65b9\u6cd5: " + method.name + ", \u63cf\u8ff0\u7b26: " + method.desc);
            }
            return method;
        }
        return null;
    }

    private byte[] processJTabbedPane(ClassNode classNode, ClassReader classReader) {
        try {
            if (debugEnabled) {
                TranslateTransformer.log("\u6b63\u5728\u5904\u7406 JTabbedPane");
            }
            for (MethodNode method : classNode.methods) {
                Type[] argTypes;
                if (!method.name.equals("addTab") && !method.name.equals("insertTab") || (argTypes = Type.getArgumentTypes(method.desc)).length < 1) continue;
                this.hookMethod(classNode, method, 1);
            }
            return this.buildClassBytes(classNode, classReader, "javax/swing/JTabbedPane");
        }
        catch (Exception exception) {
            if (debugEnabled) {
                TranslateTransformer.log("\u9519\u8bef: \u5904\u7406 JTabbedPane \u5931\u8d25: " + exception.getMessage());
                exception.printStackTrace();
            }
            return null;
        }
    }

    private byte[] processJDialog(ClassNode classNode, ClassReader classReader) {
        try {
            if (debugEnabled) {
                TranslateTransformer.log("\u6b63\u5728\u5904\u7406 JDialog");
            }
            for (MethodNode method : classNode.methods) {
                Type[] argTypes;
                if (!method.name.equals("<init>") || (argTypes = Type.getArgumentTypes(method.desc)).length != 3 || !argTypes[0].getInternalName().equals("java/awt/Frame") || !argTypes[1].getInternalName().equals("java/lang/String")) continue;
                this.hookMethod(classNode, method, 2);
                break;
            }
            return this.buildClassBytes(classNode, classReader, "javax/swing/JDialog");
        }
        catch (Exception exception) {
            if (debugEnabled) {
                TranslateTransformer.log("\u9519\u8bef: \u5904\u7406 JDialog \u5931\u8d25: " + exception.getMessage());
                exception.printStackTrace();
            }
            return null;
        }
    }

    private byte[] processClass(ClassNode classNode, ClassReader classReader) {
        try {
            if (debugEnabled) {
                TranslateTransformer.log("\u6b63\u5728\u5904\u7406 java/lang/Class");
            }
            return this.buildClassBytes(classNode, classReader, "java/lang/Class");
        }
        catch (Exception exception) {
            if (debugEnabled) {
                TranslateTransformer.log("\u9519\u8bef: \u5904\u7406 java/lang/Class \u5931\u8d25: " + exception.getMessage());
                exception.printStackTrace();
            }
            return null;
        }
    }

    private byte[] buildClassBytes(ClassNode classNode, ClassReader classReader, String className) {
        ClassWriter classWriter = new ClassWriter(classReader, 3);
        classNode.accept(classWriter);
        if (debugEnabled) {
            TranslateTransformer.log("\u6210\u529f\u8f6c\u6362\u7c7b: " + className);
        }
        return classWriter.toByteArray();
    }

    static {
        INJECTION_METHODS.put("java/awt/Frame", new InjectionMethod("setTitle", 1));
        INJECTION_METHODS.put("java/awt/Dialog", new InjectionMethod("setTitle", 1));
        INJECTION_METHODS.put("javax/swing/JLabel", new InjectionMethod("setText", 1));
        INJECTION_METHODS.put("javax/swing/AbstractButton", new InjectionMethod("setText", 1));
        INJECTION_METHODS.put("javax/swing/text/JTextComponent", new InjectionMethod("setText", 1));
        INJECTION_METHODS.put("javax/swing/text/AbstractDocument", new InjectionMethod("insertString", 2));
        INJECTION_METHODS.put("javax/swing/JComponent", new InjectionMethod("setToolTipText", 1));
        INJECTION_METHODS.put("javax/swing/JComboBox", new InjectionMethod("addItem", 1));
        INJECTION_METHODS.put("javax/swing/JOptionPane", new InjectionMethod("showOptionDialog", 2));
        INJECTION_METHODS.put("javax/swing/JEditorPane", new InjectionMethod("setText", 1));
    }

    private static class InjectionMethod {
        final String methodName;
        final int place;

        InjectionMethod(String methodName, int place) {
            this.methodName = methodName;
            this.place = place;
        }
    }
}

