/*
 * Decompiled with CFR 0.152.
 */
package Datch;

import Datch.LruCache;
import Datch.util.CommonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTextArea;
import javax.swing.plaf.synth.SynthComboBoxUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.tree.DefaultTreeCellRenderer;

public class Translator {
    static boolean debug;
    private static FileWriter FILE_WRITER;
    private static FileWriter FILE_WRITER_WHITE;
    private static FileWriter FILE_WRITER_TRANSLATED;
    private static FileWriter FILE_WRITER_ERROR;
    private static final Set<String> allCalledStrings;
    public static final String WHITE_LIST_FILE = "white.txt";
    Map<String, String> literal;
    Map<Pattern, String> regexp;
    static Map<String, String> whiteLru;
    static Map<String, String> translateLru;
    static final Pattern PATTERN;
    static final Pattern PATTERN_CHINESE;
    static final Pattern PATTERN_BYPASS_PLUGIN;
    static List<Pattern> white;
    private static final Map<String, Translator> TRANSLATOR_MAP;
    private static final File LOG_DIR;

    private static void logError(String message, Throwable throwable) {
        if (debug) {
            try {
                if (FILE_WRITER_ERROR == null) {
                    LOG_DIR.mkdirs();
                    FILE_WRITER_ERROR = new FileWriter(new File(LOG_DIR, "translator_error.txt"), true);
                }
                FILE_WRITER_ERROR.write("[" + String.valueOf(new Date()) + "] " + message + "\n");
                if (throwable != null) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    throwable.printStackTrace(printWriter);
                    FILE_WRITER_ERROR.write(stringWriter.toString() + "\n");
                }
                FILE_WRITER_ERROR.flush();
            }
            catch (Exception exception) {
                System.err.println("\u5199\u5165\u9519\u8bef\u65e5\u5fd7\u5931\u8d25: " + exception.getMessage());
            }
            System.err.println("[Translator ERROR] " + message);
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
    }

    public static void init(boolean debugEnabled) {
        debug = debugEnabled;
        if (debug) {
            LOG_DIR.mkdirs();
            try {
                FILE_WRITER = new FileWriter(new File(LOG_DIR, "unTranslate.txt"), true);
                FILE_WRITER_WHITE = new FileWriter(new File(LOG_DIR, "whitelist.txt"), true);
                FILE_WRITER_TRANSLATED = new FileWriter(new File(LOG_DIR, "translated.txt"), true);
                FILE_WRITER_ERROR = new FileWriter(new File(LOG_DIR, "translator_error.txt"), true);
                FILE_WRITER_ERROR.write("[" + String.valueOf(new Date()) + "] Translator\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u8c03\u8bd5\u6a21\u5f0f=" + debug + "\n");
                FILE_WRITER_ERROR.flush();
            }
            catch (IOException ioException) {
                System.err.println("\u521b\u5efa\u65e5\u5fd7\u6587\u4ef6\u5931\u8d25: " + ioException.getMessage());
                ioException.printStackTrace();
            }
            if (FILE_WRITER_ERROR != null) {
                try {
                    FILE_WRITER_ERROR.write("[Debug\u72b6\u6001] debug = " + debug + "\n");
                    FILE_WRITER_ERROR.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            new Thread(() -> {
                try {
                    Thread.sleep(5000L);
                    Translator.scanAndOutputUntranslated();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }, "UntranslatedScanner").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scanAndOutputUntranslated() {
        block15: {
            if (!debug || FILE_WRITER == null) {
                return;
            }
            try {
                for (int i = 0; i < 5; ++i) {
                    HashSet<String> called;
                    Thread.sleep(10000L);
                    Object object = allCalledStrings;
                    synchronized (object) {
                        called = new HashSet<String>(allCalledStrings);
                    }
                    for (String str : called) {
                        String translated;
                        boolean inWhiteList;
                        if (str == null || str.length() < 2 || PATTERN_CHINESE.matcher(str).find() || (inWhiteList = white.stream().anyMatch(pattern -> pattern.matcher(str).matches())) || (translated = translateLru.get(str)) != null && !translated.equals(str)) continue;
                        FileWriter fileWriter = FILE_WRITER;
                        synchronized (fileWriter) {
                            CommonUtil.writeFile(FILE_WRITER, str + "\t\n");
                        }
                    }
                    object = FILE_WRITER;
                    synchronized (object) {
                        if (FILE_WRITER != null) {
                            FILE_WRITER.flush();
                        }
                        continue;
                    }
                }
            }
            catch (Exception exception) {
                if (!debug) break block15;
                System.err.println("\u626b\u63cf\u672a\u7ffb\u8bd1\u5b57\u7b26\u4e32\u65f6\u51fa\u9519: " + exception.getMessage());
            }
        }
    }

    public Translator(String language) throws IOException {
        block11: {
            this.literal = new HashMap<String, String>(8192);
            this.regexp = new HashMap<Pattern, String>(1024);
            if (debug && FILE_WRITER_ERROR != null) {
                try {
                    FILE_WRITER_ERROR.write("[Translator] Hanzify By: Datch\n");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.initTranslate(this.getClass().getClassLoader().getResourceAsStream(language + ".txt"));
            try {
                File[] translationFiles = new File(CommonUtil.currentDir).listFiles(file -> {
                    String name = file.getName();
                    return name.endsWith(".txt") && name.startsWith(language);
                });
                if (translationFiles == null) break block11;
                for (File translationFile : translationFiles) {
                    if (debug && FILE_WRITER_ERROR != null) {
                        try {
                            FILE_WRITER_ERROR.write(String.format("[\u5916\u90e8\u7ffb\u8bd1\u6587\u4ef6] %s\n", translationFile.getAbsolutePath()));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.initTranslate(new FileInputStream(translationFile));
                }
            }
            catch (Exception exception) {
                if (!debug || FILE_WRITER_ERROR == null) break block11;
                try {
                    FILE_WRITER_ERROR.write("[\u5916\u90e8\u7ffb\u8bd1\u8bed\u8a00\u9519\u8bef] " + exception.getMessage() + "\n");
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    exception.printStackTrace(printWriter);
                    FILE_WRITER_ERROR.write(stringWriter.toString() + "\n");
                    FILE_WRITER_ERROR.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void initTranslate(InputStream inputStream) throws IOException {
        block11: {
            if (inputStream == null) {
                return;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                reader.lines().distinct().filter(line -> !line.isEmpty() && !line.startsWith("#")).forEach(line -> {
                    String[] parts;
                    if (debug && FILE_WRITER_ERROR != null) {
                        try {
                            FILE_WRITER_ERROR.write("[\u7ffb\u8bd1\u6761\u76ee] " + line + "\n");
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if ((parts = line.split("\t", 2)).length != 2) {
                        if (debug && FILE_WRITER_ERROR != null) {
                            try {
                                FILE_WRITER_ERROR.write("[Invalid line] " + line + "\n");
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                    if (PATTERN.matcher(parts[1]).matches() || parts[0].contains("(?i)")) {
                        try {
                            Pattern compiledPattern = Pattern.compile("(?m)^" + parts[0] + "$");
                            this.regexp.put(compiledPattern, parts[1].replace("\"", "\\\""));
                            if (debug) {
                                Set<String> set = allCalledStrings;
                                synchronized (set) {
                                    allCalledStrings.add(parts[0]);
                                }
                            }
                            return;
                        }
                        catch (PatternSyntaxException patternException) {
                            if (debug && FILE_WRITER_ERROR != null) {
                                try {
                                    FILE_WRITER_ERROR.write("[PatternSyntaxException] " + parts[0] + "\n");
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return;
                        }
                    }
                    this.literal.put(parts[0], parts[1]);
                    if (debug) {
                        Set<String> set = allCalledStrings;
                        synchronized (set) {
                            allCalledStrings.add(parts[0]);
                        }
                    }
                });
                if (debug && FILE_WRITER_ERROR != null) {
                    try {
                        FILE_WRITER_ERROR.write(String.format("[\u521d\u59cb\u5316\u72b6\u6001] literal %d regex %d white %d\n", this.literal.size(), this.regexp.size(), white.size()));
                        FILE_WRITER_ERROR.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                if (!debug) break block11;
                System.err.println("\u65e0\u6cd5\u7ffb\u8bd1\u5b57\u7b26\u4e32");
                exception.printStackTrace();
            }
        }
    }

    private static void initWhiteList(InputStream inputStream) throws IOException {
        block8: {
            if (inputStream == null) {
                return;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                reader.lines().distinct().filter(line -> !line.isEmpty() && !line.startsWith("#")).map(Pattern::compile).forEach(pattern -> white.add((Pattern)pattern));
            }
            catch (Exception exception) {
                if (!debug) break block8;
                System.err.println("\u65e0\u6cd5\u6dfb\u52a0\u767d\u540d\u5355\u5b57\u7b26\u4e32");
                exception.printStackTrace();
            }
        }
    }

    public static String translate(Object src, String lang, String str) {
        try {
            if (str == null) {
                return null;
            }
            if (debug && str.contains("Are you sure") && FILE_WRITER_ERROR != null) {
                try {
                    FILE_WRITER_ERROR.write("[\u7279\u5b9a\u5b57\u7b26\u4e32] " + (src != null ? src.toString() : "null") + str + "\n");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (src != null && src.getClass().getName().equals("burp.Zf8t")) {
                if (debug && FILE_WRITER_ERROR != null) {
                    try {
                        FILE_WRITER_ERROR.write("[Translator] Processing burp.Zf8t: " + str + "\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return Translator.translate(lang, str);
            }
            if (src != null && src.getClass().getName().equals("burp.Zf8i")) {
                if (debug && FILE_WRITER_ERROR != null) {
                    try {
                        FILE_WRITER_ERROR.write("[Translator] Processing burp.Zf8i: " + str + "\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return Translator.translate(lang, str);
            }
            if (src instanceof DefaultTreeCellRenderer && src != null && src.getClass().getName().startsWith("burp.")) {
                if (debug && FILE_WRITER_ERROR != null) {
                    try {
                        FILE_WRITER_ERROR.write("[Translator] Processing burp DefaultTreeCellRenderer subclass: " + src.getClass().getName() + " - " + str + "\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return Translator.translate(lang, str);
            }
            if (src instanceof PlainDocument && !src.getClass().equals(PlainDocument.class) || src instanceof JTextComponent && ((JTextComponent)src).isEditable() || src instanceof JTextArea || src instanceof DefaultStyledDocument && !src.getClass().getName().contains("DefaultStyledDocument") || src instanceof DefaultTreeCellRenderer || src instanceof DefaultTableCellRenderer && !src.getClass().getName().contains("DefaultTableCellHeaderRenderer") || src.getClass().equals(SynthComboBoxUI.class)) {
                if (debug && FILE_WRITER_ERROR != null) {
                    try {
                        FILE_WRITER_ERROR.write("[\u8fc7\u6ee4\u8f93\u5165] " + (src != null ? src.getClass().getName() : "null") + "\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return str;
            }
            return Translator.translate(lang, str);
        }
        catch (Exception exception) {
            Translator.logError("Error in translate(Object, String, String) for: " + str, exception);
            return str;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String translate(String lang, String str) {
        try {
            if (str == null || str.length() < 2) {
                return str;
            }
            if (lang.contains("cn") && PATTERN_CHINESE.matcher(str).find()) {
                if (debug && FILE_WRITER_ERROR != null) {
                    try {
                        FILE_WRITER_ERROR.write("[\u4e2d\u6587\u5b57\u7b26\u4e32] " + str + "\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return str;
            }
            if (whiteLru.get(str) != null) {
                return str;
            }
            String translated = translateLru.get(str);
            if (translated != null) {
                return translated;
            }
            if (white.stream().anyMatch(pattern -> pattern.matcher(str).matches())) {
                if (debug && FILE_WRITER_WHITE != null) {
                    CommonUtil.writeFile(FILE_WRITER_WHITE, str + "\t\n");
                }
                whiteLru.put(str, "");
                return str;
            }
            Translator translator = TRANSLATOR_MAP.get(lang);
            if (translator == null) {
                translator = new Translator(lang);
                TRANSLATOR_MAP.put(lang, translator);
            }
            StringBuilder result = new StringBuilder();
            if (str.contains(" | ")) {
                if (debug && FILE_WRITER_ERROR != null) {
                    try {
                        FILE_WRITER_ERROR.write("[\u8fc7\u6ee4\u7ffb\u8bd1] " + str + "\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                for (String part : str.split(" \\| ")) {
                    if (result.length() > 0) {
                        result.append(" | ");
                    }
                    if (part.contains("; ")) {
                        String[] segments = part.split(";  ");
                        for (int i = 0; i < segments.length; ++i) {
                            if (i != 0) {
                                result.append(";  ");
                            }
                            result.append(translator.translate(segments[i]));
                        }
                        continue;
                    }
                    result.append(translator.translate(part));
                }
            } else {
                for (String line : str.split("\n")) {
                    if (result.length() > 0) {
                        result.append("\n");
                    }
                    result.append(translator.translate(line));
                }
            }
            String translatedResult = result.toString();
            if (debug) {
                Set<String> set = allCalledStrings;
                synchronized (set) {
                    allCalledStrings.add(str);
                }
                if (FILE_WRITER_TRANSLATED != null) {
                    CommonUtil.writeFile(FILE_WRITER_TRANSLATED, str + "\t" + translatedResult + "\n");
                }
                if (str.equals(translatedResult) && FILE_WRITER != null) {
                    Object caller = "";
                    try {
                        StackTraceElement[] stack;
                        for (StackTraceElement element : stack = Thread.currentThread().getStackTrace()) {
                            String className = element.getClassName();
                            if (className.equals(Translator.class.getName()) || className.equals("java.lang.Thread") || className.startsWith("java.lang.reflect") || className.startsWith("sun.reflect") || className.startsWith("jdk.internal")) continue;
                            caller = className + "." + element.getMethodName() + "(" + element.getLineNumber() + ")";
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CommonUtil.writeFile(FILE_WRITER, str + "\t\t# FROM: " + (String)caller + "\n");
                }
            }
            translateLru.put(str, translatedResult);
            return translatedResult;
        }
        catch (Exception exception) {
            Translator.logError("Error in translate(String, String) for: " + str, exception);
            return str;
        }
    }

    public String translate(String str) {
        if (str == null || str.length() < 2) {
            return str;
        }
        String translated = this.literal.get(str.trim());
        if (translated == null) {
            translated = str;
            for (Map.Entry<Pattern, String> entry : this.regexp.entrySet()) {
                Matcher matcher = entry.getKey().matcher(translated);
                if (!matcher.matches()) continue;
                translated = matcher.replaceAll(entry.getValue());
            }
        }
        return translated;
    }

    static {
        allCalledStrings = new HashSet<String>();
        PATTERN = Pattern.compile(".*\\$\\d.*");
        PATTERN_CHINESE = Pattern.compile("\\p{IsHan}+");
        PATTERN_BYPASS_PLUGIN = Pattern.compile("Custom|Variables|Encode|Decode|String|Convert|Math|Hash|HMAC|Fake|Charsets|Compression|Date|Loops|Encrypt|Decrypt|Languages|System|XSS|Search");
        white = new ArrayList<Pattern>(128);
        TRANSLATOR_MAP = new HashMap<String, Translator>(2);
        LOG_DIR = CommonUtil.currentDir != null ? new File(CommonUtil.currentDir, "log") : new File("log");
        try {
            Translator.initWhiteList(Translator.class.getClassLoader().getResourceAsStream(WHITE_LIST_FILE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Translator.initWhiteList(new FileInputStream(WHITE_LIST_FILE));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException ioException) {
            System.err.println("Error reading whitelist file: white.txt");
        }
        whiteLru = new LruCache<String, String>(2048);
        translateLru = new LruCache<String, String>(8192);
    }
}

