/*
 * Decompiled with CFR 0.152.
 */
package Datch;

import Datch.util.CommonUtil;
import Datch.util.Keygen;
import Datch.util.SpringUtilities;
import Datch.util.TextFieldChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.UIManager;

public class KeygenDialog {
    private static final String TITLE = "Burp Suite \u7834\u89e3 & \u6c49\u5316\u5de5\u5177 V1.1 - By Datch";
    public static final int WIDTH = 880;
    public static final int HEIGHT = 600;
    private JPanel root;
    private JTextField tfLicenseName;
    private JTextArea taLicense;
    private JTextArea taRequest;
    private JTextArea taResponse;
    private JTextField tfLoader;
    private JButton btnRun;
    private JCheckBox cbLoader;
    private JCheckBox cbTranslateOnly;
    private JCheckBox cbAutoStart;
    private JCheckBox cbDebug;

    private KeygenDialog() {
        this.setupUI();
        this.tfLicenseName.getDocument().addDocumentListener(new TextFieldChangedListener((event, type) -> {
            if (!this.tfLicenseName.getText().isEmpty()) {
                this.taLicense.setText(Keygen.generateLicense(this.tfLicenseName.getText()));
            }
        }));
        this.taRequest.getDocument().addDocumentListener(new TextFieldChangedListener((event, type) -> {
            if (!this.taRequest.getText().isEmpty()) {
                this.taResponse.setText(Keygen.generateActivation(this.taRequest.getText()));
            }
        }));
        this.btnRun.addActionListener(event -> {
            try {
                CommonUtil.executeCmd(this.tfLoader.getText());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
        this.tfLicenseName.addPropertyChangeListener(evt -> this.taLicense.setText(Keygen.generateLicense(this.tfLicenseName.getText())));
    }

    private static void showKeygenDialog() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("\u8bbe\u7f6e\u5916\u89c2\u5931\u8d25 " + String.valueOf(exception));
        }
        JFrame frame = new JFrame(TITLE);
        frame.setContentPane(new KeygenDialog().root);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
        frame.setLocationRelativeTo(null);
    }

    private void setupUI() {
        this.root = new JPanel(new SpringLayout());
        this.root.setPreferredSize(new Dimension(880, 600));
        this.root.setBorder(BorderFactory.createTitledBorder(null, TITLE, 2, 2));
        int leftLabelWidth = 90;
        int leftLabelHeight = 24;
        JLabel labelHint = new JLabel("\u4f7f\u7528\u8bf4\u660e:", 11);
        labelHint.setHorizontalAlignment(4);
        labelHint.setPreferredSize(new Dimension(90, 24));
        this.root.add(labelHint);
        JLabel labelInstruction = new JLabel("<html><body>1. \u4f7f\u7528\u6307\u5b9a\u7684\u52a0\u8f7d\u5668\u8fd0\u884c Burp Suite Pro \u4e14\u6587\u4ef6\u540d\u5e94\u4e3aburpsuite_*.jar<br>2. \u4f7f\u7528\u624b\u52a8\u6fc0\u6d3b\u65b9\u5f0f\u6ce8\u518c<br>3. \u540e\u7eed\u8fd0\u884c\u65f6\u5fc5\u987b\u4f7f\u7528\u52a0\u8f7d\u5668\u542f\u52a8\uff0c\u5426\u5219\u4f1a\u53d8\u4e3a\u672a\u6ce8\u518c\u72b6\u6001<body></html>");
        this.root.add(labelInstruction);
        JLabel labelCommand = new JLabel("\u542f\u52a8\u547d\u4ee4:", 11);
        labelCommand.setVerticalAlignment(0);
        labelCommand.setHorizontalAlignment(4);
        labelCommand.setPreferredSize(new Dimension(90, 24));
        this.root.add(labelCommand);
        this.tfLoader = new JTextField(CommonUtil.getLaunchCommand());
        this.tfLoader.setPreferredSize(new Dimension(0, 24));
        this.tfLoader.setMinimumSize(new Dimension(0, 24));
        boolean editLoader = CommonUtil.PREFERENCES.getBoolean("edit loader", false);
        this.tfLoader.setEditable(editLoader);
        this.root.add(this.tfLoader);
        JLabel spacer = new JLabel("", 11);
        spacer.setPreferredSize(new Dimension(90, 24));
        this.root.add(spacer);
        JPanel optionsPanel = new JPanel(new FlowLayout(1, 10, 0));
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.cbLoader = new JCheckBox("\u7834\u89e3", null, CommonUtil.PREFERENCES.getBoolean("loader", true));
        this.cbLoader.addActionListener(event -> this.handleCheckBoxChange(event.getSource(), "loader"));
        optionsPanel.add(this.cbLoader);
        this.cbTranslateOnly = new JCheckBox("\u6c49\u5316", null, CommonUtil.PREFERENCES.getBoolean("hanizfy", true));
        this.cbTranslateOnly.addActionListener(event -> this.handleCheckBoxChange(event.getSource(), "hanizfy"));
        optionsPanel.add(this.cbTranslateOnly);
        this.cbAutoStart = new JCheckBox("\u5feb\u901f\u8fd0\u884c", null, CommonUtil.PREFERENCES.getBoolean("auto start", false));
        this.cbAutoStart.addActionListener(event -> this.handleCheckBoxChange(event.getSource(), "auto start"));
        optionsPanel.add(this.cbAutoStart);
        this.cbDebug = new JCheckBox("\u8c03\u8bd5", null, CommonUtil.PREFERENCES.getBoolean("debug", false));
        this.cbDebug.addActionListener(event -> this.handleCheckBoxChange(event.getSource(), "debug"));
        optionsPanel.add(this.cbDebug);
        this.btnRun = new JButton("\u8fd0\u884c");
        this.btnRun.setEnabled(CommonUtil.hasBurpJar());
        optionsPanel.add(this.btnRun);
        this.root.add(optionsPanel);
        JLabel labelLicensee = new JLabel("\u6388\u6743\u5bf9\u8c61:", 11);
        labelLicensee.setHorizontalAlignment(4);
        labelLicensee.setPreferredSize(new Dimension(90, 24));
        this.root.add(labelLicensee);
        this.tfLicenseName = new JTextField("\u6388\u6743\u7ed9 Datch");
        boolean editLicense = CommonUtil.PREFERENCES.getBoolean("edit license", false);
        this.tfLicenseName.setEditable(editLicense);
        this.tfLicenseName.setHorizontalAlignment(0);
        this.root.add(this.tfLicenseName);
        JLabel labelLic = new JLabel("\u6388\u6743\u8bb8\u53ef:", 11);
        labelLic.setHorizontalAlignment(4);
        labelLic.setPreferredSize(new Dimension(90, 24));
        this.root.add(labelLic);
        this.taLicense = new JTextArea(null, null, 5, 0);
        this.taLicense.setEditable(false);
        this.taLicense.setLineWrap(true);
        this.taLicense.setRows(5);
        JScrollPane licScrollPane = new JScrollPane(this.taLicense);
        JButton btnLicense = new JButton("\u590d\u5236");
        btnLicense.setPreferredSize(new Dimension(80, 30));
        btnLicense.addActionListener(event -> CommonUtil.copy(this.taLicense.getText()));
        JPanel licPanel = new JPanel(new BorderLayout(6, 0));
        licPanel.add((Component)licScrollPane, "Center");
        licPanel.add((Component)btnLicense, "East");
        this.root.add(licPanel);
        JLabel labelReq = new JLabel("\u6fc0\u6d3b\u8bf7\u6c42:", 11);
        labelReq.setHorizontalAlignment(4);
        labelReq.setPreferredSize(new Dimension(90, 24));
        this.root.add(labelReq);
        JButton btnRequest = new JButton("\u7c98\u8d34");
        btnRequest.setPreferredSize(new Dimension(80, 30));
        btnRequest.addActionListener(event -> this.taRequest.setText(CommonUtil.pasteString()));
        this.taRequest = new JTextArea(null, null, 5, 0);
        this.taRequest.setLineWrap(true);
        JScrollPane scrollPaneReq = new JScrollPane(this.taRequest);
        JPanel reqPanel = new JPanel(new BorderLayout(6, 0));
        reqPanel.add((Component)scrollPaneReq, "Center");
        reqPanel.add((Component)btnRequest, "East");
        this.root.add(reqPanel);
        JLabel labelRsp = new JLabel("\u6fc0\u6d3b\u54cd\u5e94:", 11);
        labelRsp.setHorizontalAlignment(4);
        labelRsp.setPreferredSize(new Dimension(90, 24));
        this.root.add(labelRsp);
        JButton btnResponse = new JButton("\u590d\u5236");
        btnResponse.setPreferredSize(new Dimension(80, 30));
        btnResponse.addActionListener(event -> CommonUtil.copy(this.taResponse.getText()));
        this.taResponse = new JTextArea(null, null, 6, 0);
        this.taResponse.setLineWrap(true);
        JScrollPane scrollPaneResponse = new JScrollPane(this.taResponse);
        JPanel rspPanel = new JPanel(new BorderLayout(6, 0));
        rspPanel.add((Component)scrollPaneResponse, "Center");
        rspPanel.add((Component)btnResponse, "East");
        this.root.add(rspPanel);
        SpringUtilities.makeCompactGrid(this.root, 7, 2, 6, 6, 6, 6);
    }

    private void handleCheckBoxChange(Object source, String preferenceKey) {
        JCheckBox checkBox = (JCheckBox)source;
        CommonUtil.PREFERENCES.putBoolean(preferenceKey, checkBox.isSelected());
        this.tfLoader.setText(CommonUtil.getLaunchCommand(this.cbLoader.isSelected(), this.cbTranslateOnly.isSelected(), this.cbDebug.isSelected()));
    }

    public static void main(String[] args) throws IOException {
        boolean autoStart = CommonUtil.PREFERENCES.getBoolean("auto start", false);
        if (autoStart && !Arrays.asList(args).contains("-r")) {
            String currentJarName = "BurpKeygenCN.jar";
            try {
                File jarFile = new File(KeygenDialog.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                if (jarFile.isFile() && jarFile.getName().endsWith(".jar")) {
                    currentJarName = jarFile.getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("\u5feb\u901f\u8fd0\u884c\u5df2\u5f00\u542f\u3002\u5982\u9700\u8fd0\u884c\u6ce8\u518c\u673a\uff0c\u8bf7\u6dfb\u52a0 -r \u53c2\u6570\uff1ajava -jar " + currentJarName + " -r");
        }
        if (autoStart && args.length == 0) {
            CommonUtil.executeCmd(CommonUtil.getLaunchCommand());
        } else {
            KeygenDialog.showKeygenDialog();
        }
    }
}

