/*
 * Decompiled with CFR 0.152.
 */
package Datch;

import Datch.Translator;
import Datch.transformer.TranslateTransformer;
import Datch.util.CommonUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.util.Date;

public class Agent {
    public static final String LOADER = "loader";
    public static final String BOTH = "loader,han";
    public static final String HAN = "han";
    private static FileWriter AGENT_LOG_WRITER;
    private static boolean debugEnabled;

    private static void log(String message) {
        if (debugEnabled && AGENT_LOG_WRITER != null) {
            try {
                AGENT_LOG_WRITER.write("[" + String.valueOf(new Date()) + "] " + message + "\n");
                AGENT_LOG_WRITER.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (debugEnabled) {
            System.out.println("[Agent] " + message);
        }
    }

    static void flushLogs() {
        if (AGENT_LOG_WRITER != null) {
            try {
                AGENT_LOG_WRITER.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void logError(String message, Throwable e) {
        if (debugEnabled) {
            try {
                if (AGENT_LOG_WRITER == null) {
                    File logDir = new File(CommonUtil.currentDir, "log");
                    logDir.mkdirs();
                    AGENT_LOG_WRITER = new FileWriter(new File(logDir, "agent_log.txt"), true);
                }
                AGENT_LOG_WRITER.write("[" + String.valueOf(new Date()) + "] ERROR: " + message + "\n");
                if (e != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    AGENT_LOG_WRITER.write(sw.toString() + "\n");
                }
                AGENT_LOG_WRITER.flush();
            }
            catch (Exception exception) {
                System.err.println("\u5199\u5165\u4ee3\u7406\u9519\u8bef\u65e5\u5fd7\u5931\u8d25: " + exception.getMessage());
            }
            System.err.println("[Agent ERROR] " + message);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    public static void premain(String args, Instrumentation instrumentation) {
        if (args != null && args.contains("debug")) {
            debugEnabled = true;
        }
        if (debugEnabled) {
            File logDirectory = new File(CommonUtil.currentDir != null ? CommonUtil.currentDir : ".", "log");
            logDirectory.mkdirs();
            try {
                AGENT_LOG_WRITER = new FileWriter(new File(logDirectory, "agent_log.txt"), true);
                Agent.log("Agent\u7c7b\u5df2\u52a0\u8f7d\uff0c\u8c03\u8bd5\u6a21\u5f0f=" + debugEnabled);
            }
            catch (IOException ioException) {
                System.err.println("\u521b\u5efa\u4ee3\u7406\u65e5\u5fd7\u5931\u8d25: " + ioException.getMessage());
                ioException.printStackTrace();
            }
        }
        Translator.init(debugEnabled);
        TranslateTransformer.init(debugEnabled);
        try {
            boolean useHanzify;
            long startTime;
            block20: {
                startTime = System.currentTimeMillis();
                Agent.log("premain\u88ab\u8c03\u7528\uff0c\u53c2\u6570: " + args);
                Agent.log("Java\u7248\u672c: " + System.getProperty("java.version"));
                Agent.log("Java home: " + System.getProperty("java.home"));
                Agent.log("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
                Agent.log("\u7528\u6237\u8bed\u8a00: " + System.getProperty("user.language") + "_" + System.getProperty("user.country"));
                if (args == null) {
                    args = BOTH;
                    Agent.log("\u53c2\u6570\u4e3a\u7a7a\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c: " + args);
                }
                boolean useLoader = args.contains(LOADER);
                useHanzify = args.contains(HAN);
                Agent.log("useLoader=" + useLoader + ", useHanzify=" + useHanzify);
                if (!useLoader && !useHanzify) {
                    Agent.log("\u672a\u542f\u7528\u4efb\u4f55\u8f6c\u6362\u5668\uff0c\u6b63\u5728\u9000\u51fa");
                    if (debugEnabled) {
                        System.err.println("\u672a\u4f7f\u7528\u4efb\u4f55\u8f6c\u6362\u5668");
                    }
                    return;
                }
                try {
                    Class<?> transformerClass = Class.forName("Datch.transformer.PatcherTransformer");
                    if (useLoader) {
                        Agent.log("\u6b63\u5728\u6dfb\u52a0PatcherTransformer (Loader)");
                        if (debugEnabled) {
                            System.out.println("\u4f7f\u7528Loader\u8f6c\u6362\u5668");
                        }
                        instrumentation.addTransformer((ClassFileTransformer)transformerClass.newInstance());
                    }
                }
                catch (Exception exception) {
                    Agent.logError("PatcherTransformer\u672a\u627e\u5230\u6216\u52a0\u8f7d\u5931\u8d25", exception);
                    if (!debugEnabled) break block20;
                    System.err.println("PatcherTransformer\u672a\u627e\u5230");
                }
            }
            if (useHanzify) {
                try {
                    Agent.log("\u6b63\u5728\u6dfb\u52a0TranslateTransformer (\u6c49\u5316)");
                    if (debugEnabled) {
                        System.out.println("\u4f7f\u7528\u6c49\u5316\u8f6c\u6362\u5668");
                    }
                    instrumentation.addTransformer(new TranslateTransformer(), true);
                    Agent.log("TranslateTransformer\u6dfb\u52a0\u6210\u529f");
                }
                catch (Exception exception) {
                    Agent.logError("\u6dfb\u52a0TranslateTransformer\u5931\u8d25", exception);
                    throw exception;
                }
            }
            try {
                Agent.log("\u6b63\u5728\u91cd\u8f6c\u6362java.lang.Class");
                for (Class loadedClass : instrumentation.getAllLoadedClasses()) {
                    if (!loadedClass.getName().equals("java.lang.Class")) continue;
                    instrumentation.retransformClasses(loadedClass);
                    Agent.log("java.lang.Class\u91cd\u8f6c\u6362\u5b8c\u6210");
                    break;
                }
            }
            catch (Exception exception) {
                Agent.logError("\u91cd\u8f6c\u6362\u7c7b\u5931\u8d25", exception);
            }
            Agent.log("premain\u6267\u884c\u6210\u529f\uff0c\u8017\u65f6 " + (System.currentTimeMillis() - startTime) + "ms");
        }
        catch (Exception exception) {
            Agent.logError("premain\u53d1\u751f\u81f4\u547d\u9519\u8bef", exception);
        }
    }
}

