/*
 * Decompiled with CFR 0.152.
 */
package leon406.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.prefs.Preferences;
import leon406.KeygenDialog;

public class CommonUtil {
    public static final String NOT_FOUND_JAR = "burpsuite_jar_not_found.jar";
    public static String currentDir = null;
    public static String burpJarName;
    public static final String ENV_BP_JAVA_HOME = "bp.java";
    public static final String BP_JAVA_HOME;
    public static final String ENV_BP_JAVA_OPT = "bp.java.options";
    public static final String BP_JAVA_OPT;
    public static final String LOADER_JAR_NAME;
    public static final String KEY_AUTO_START = "auto start";
    public static final String KEY_LOADER = "loader";
    public static final String KEY_HANZIFY = "hanizfy";
    private static final Executor LOG_EXECUTOR;
    static Toolkit toolkit;
    static Clipboard clipboard;
    public static final Preferences PREFERENCES;

    public static String getLaunchCommand() {
        int javaVersion;
        StringBuilder command = new StringBuilder();
        File jre = new File(currentDir, "jre" + File.separator + "bin");
        if (jre.exists()) {
            command.append(jre.getAbsolutePath()).append(File.separator);
        } else {
            jre = new File(currentDir, "bin");
            if (jre.exists()) {
                command.append(jre.getAbsolutePath()).append(File.separator);
            } else if (BP_JAVA_HOME != null) {
                command.append(BP_JAVA_HOME).append(File.separator);
            }
        }
        command.append("java").append(" -XX:+IgnoreUnrecognizedVMOptions");
        if (BP_JAVA_OPT != null) {
            command.append(" ").append(BP_JAVA_OPT);
        }
        if (!LOADER_JAR_NAME.isEmpty()) {
            command.append(" -javaagent:").append(LOADER_JAR_NAME);
            StringBuilder sb = new StringBuilder();
            boolean loader = PREFERENCES.getBoolean(KEY_LOADER, false);
            boolean han = PREFERENCES.getBoolean(KEY_HANZIFY, true);
            if (loader) {
                sb.append(KEY_LOADER).append(",");
            }
            if (han) {
                sb.append(KEY_HANZIFY);
            }
            command.append("=").append((CharSequence)sb);
        }
        if ((javaVersion = Integer.parseInt(System.getProperty("java.version", "8").split("\\.")[0])) < 11) {
            command.delete(0, command.length() - 1).append("upgrade jdk to 11+!!!");
        } else if (javaVersion >= 11) {
            command.append(" --add-opens=java.desktop/javax.swing=ALL-UNNAMED");
            command.append(" --add-opens=java.base/java.lang=ALL-UNNAMED");
            command.append(" --add-opens=java.base/jdk.internal.org.objectweb.asm=ALL-UNNAMED");
            command.append(" --add-opens=java.base/jdk.internal.org.objectweb.asm.tree=ALL-UNNAMED");
            command.append(" --add-opens=java.base/jdk.internal.org.objectweb.asm.Opcodes=ALL-UNNAMED");
            if (javaVersion < 13) {
                command.append(" -noverify");
            }
            if (javaVersion == 16) {
                command.append(" --illegal-access=permit");
            }
            command.append(" -jar ").append(burpJarName);
        }
        return command.toString();
    }

    public static String getNewestFile(String dir, String glob) {
        long lastModified = 0L;
        String latestFile = "";
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(dir, new String[0]), glob);){
            for (Path path : dirStream) {
                if (Files.isDirectory(path, new LinkOption[0]) || lastModified >= path.toFile().lastModified()) continue;
                lastModified = path.toFile().lastModified();
                latestFile = path.getFileName().toString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return latestFile;
    }

    public static boolean hasBurpJar() {
        return !NOT_FOUND_JAR.equals(burpJarName) && !LOADER_JAR_NAME.isEmpty();
    }

    public static void copy(String text) {
        clipboard.setContents(new StringSelection(text), null);
    }

    public static String pasteString() {
        Transferable trans = clipboard.getContents(null);
        if (trans != null && trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                return (String)trans.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void executeCmd(String command) {
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            System.err.println("launchBurp error " + e1);
        }
    }

    public static void writeFile(FileWriter fileWriter, String msg) {
        LOG_EXECUTOR.execute(() -> {
            try {
                fileWriter.write(msg);
                fileWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    static {
        LOG_EXECUTOR = Executors.newSingleThreadExecutor();
        toolkit = Toolkit.getDefaultToolkit();
        clipboard = toolkit.getSystemClipboard();
        PREFERENCES = Preferences.userNodeForPackage(KeygenDialog.class);
        try {
            File f = new File(KeygenDialog.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            currentDir = f.isDirectory() ? f.getPath() : f.getParentFile().toString();
            System.out.println("currentDir: " + currentDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        burpJarName = CommonUtil.getNewestFile(currentDir, "burpsuite_*.jar");
        if (Objects.equals(burpJarName, "")) {
            burpJarName = NOT_FOUND_JAR;
        }
        LOADER_JAR_NAME = CommonUtil.getNewestFile(currentDir, "burpsuitloader*.jar");
        BP_JAVA_HOME = System.getenv(ENV_BP_JAVA_HOME);
        BP_JAVA_OPT = System.getenv(ENV_BP_JAVA_OPT);
    }
}

