/*
 * Decompiled with CFR 0.152.
 */
package leon406.transformer;

import java.io.ByteArrayInputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import leon406.transformer.ResourceTransformer;

public class TranslateTransformer
implements ClassFileTransformer {
    static ClassPool classPool = ClassPool.getDefault();
    static Map<String, InjectionMethod> injectionMethods = new HashMap<String, InjectionMethod>(16);
    String lang = "cn";

    CtBehavior insertTranslateCommand(CtBehavior ctBehavior, int i) throws Exception {
        this.hook(ctBehavior, i);
        return ctBehavior;
    }

    @Override
    public byte[] transform(ClassLoader classLoader, String className, Class<?> cls, ProtectionDomain protectionDomain, byte[] bArr) throws IllegalClassFormatException {
        return this.transform(className, bArr);
    }

    private void hook(CtBehavior ctMethod, int n) throws CannotCompileException {
        StringBuilder src = new StringBuilder();
        src.append("{");
        src.append("ClassLoader classLoader = ClassLoader.getSystemClassLoader();");
        src.append("Class translator = classLoader.loadClass(\"leon406.Translator\");");
        if ((ctMethod.getModifiers() & 8) != 0) {
            src.append("java.lang.reflect.Method method = translator.getDeclaredMethod(\"translate\", new Class[]{String.class, String.class});");
            src.append(String.format("if($%d instanceof String){$%d = (String)method.invoke(null, new Object[]{\"" + this.lang + "\", $%d});}", n, n, n));
        } else {
            src.append("java.lang.reflect.Method method = translator.getDeclaredMethod(\"translate\", new Class[]{Object.class, String.class, String.class});");
            src.append(String.format("if($%d instanceof String){$%d = (String)method.invoke(null, new Object[]{$0, \"" + this.lang + "\", $%d});}", n, n, n));
        }
        src.append("}");
        ctMethod.insertBefore(src.toString());
    }

    private byte[] transform(String className, byte[] bArr) throws IllegalClassFormatException {
        if (!(className.startsWith("java/awt") || className.startsWith("javax/swing") || "java/lang/Class".equals(className))) {
            return null;
        }
        try {
            CtClass makeClass = classPool.makeClass(new ByteArrayInputStream(bArr));
            InjectionMethod injectionMethod = injectionMethods.get(className);
            if (injectionMethod != null) {
                this.insertTranslateCommand(makeClass.getDeclaredMethod(injectionMethod.methodName), injectionMethod.place);
                return makeClass.toBytecode();
            }
            if ("javax/swing/JTabbedPane".equals(className)) {
                this.insertTranslateCommand(makeClass.getDeclaredMethod("addTab"), 1);
                this.insertTranslateCommand(makeClass.getDeclaredMethod("insertTab"), 1);
                return makeClass.toBytecode();
            }
            if ("javax/swing/JDialog".equals(className)) {
                this.insertTranslateCommand(makeClass.getDeclaredConstructor(new CtClass[]{classPool.get("java.awt.Frame"), classPool.get("java.lang.String"), CtClass.booleanType}), 2);
                return makeClass.toBytecode();
            }
            if (!"java/lang/Class".equals(className)) {
                return null;
            }
            makeClass.instrument(new ResourceTransformer("cn"));
            return makeClass.toBytecode();
        }
        catch (Exception e) {
            IllegalClassFormatException illegalClassFormatException = new IllegalClassFormatException();
            System.err.println("init error");
            e.printStackTrace();
            illegalClassFormatException.initCause(e);
            throw illegalClassFormatException;
        }
    }

    static {
        injectionMethods.put("java/awt/Frame", new InjectionMethod("setTitle", 1));
        injectionMethods.put("java/awt/Dialog", new InjectionMethod("setTitle", 1));
        injectionMethods.put("javax/swing/JLabel", new InjectionMethod("setText", 1));
        injectionMethods.put("javax/swing/AbstractButton", new InjectionMethod("setText", 1));
        injectionMethods.put("javax/swing/text/JTextComponent", new InjectionMethod("setText", 1));
        injectionMethods.put("javax/swing/text/AbstractDocument", new InjectionMethod("insertString", 2));
        injectionMethods.put("javax/swing/JComponent", new InjectionMethod("setToolTipText", 1));
        injectionMethods.put("javax/swing/JComboBox", new InjectionMethod("addItem", 1));
        injectionMethods.put("javax/swing/JOptionPane", new InjectionMethod("showOptionDialog", 2));
        injectionMethods.put("javax/swing/JEditorPane", new InjectionMethod("setText", 1));
    }

    static class InjectionMethod {
        String methodName;
        int place;

        public InjectionMethod(String methodName, int place) {
            this.methodName = methodName;
            this.place = place;
        }
    }
}

