/*
 * Decompiled with CFR 0.152.
 */
package leon406;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTextArea;
import javax.swing.plaf.synth.SynthComboBoxUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.tree.DefaultTreeCellRenderer;
import leon406.LruCache;
import leon406.util.CommonUtil;

public class Translator {
    static final Pattern PATTERN = Pattern.compile(".*\\$\\d.*");
    static final Pattern PATTERN_CHINESE = Pattern.compile("[\u4e00-\u9fa5]+");
    static final Pattern PATTERN_BYPASS_PLUGIN = Pattern.compile("Custom|Variables|Encode|Decode|String|Convert|Math|Hash|HMAC|Fake|Charsets|Compression|Date|Loops|Encrypt|Decrypt|Languages|System|XSS|Search");
    static boolean debug;
    static List<Pattern> white;
    private static final Map<String, Translator> TRANSLATOR_MAP;
    private static final File LOG_DIR;
    private static FileWriter FILE_WRITER;
    private static FileWriter FILE_WRITER_WHITE;
    private static FileWriter FILE_WRITER_TRANSLATED;
    public static final String WHITE_LIST_FILE = "white.txt";
    Map<String, String> literal = new HashMap<String, String>(8192);
    Map<Pattern, String> regexp = new HashMap<Pattern, String>(1024);
    static Map<String, String> whiteLru;
    static Map<String, String> translateLru;

    public Translator(String str) {
        String translateFile = str + ".txt";
        System.out.println("Hanzify By: Leon406 & Datch");
        this.initTranslate(this.getClass().getClassLoader().getResourceAsStream(translateFile));
        try {
            File[] cns = new File(CommonUtil.currentDir).listFiles(file -> {
                String name = file.getName();
                return name.endsWith(".txt") && name.startsWith(str);
            });
            if (cns != null) {
                for (File cn : cns) {
                    System.out.printf("detect outer CN  %s\n", cn.getAbsolutePath());
                    this.initTranslate(new FileInputStream(cn));
                }
            }
        }
        catch (Exception cns) {
            cns.printStackTrace();
            System.err.println("Outer translate language error: " + cns.getMessage());
        }
    }

    private void initTranslate(InputStream is) {
        if (is == null) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            br.lines().distinct().filter(s -> !s.isEmpty() && !s.startsWith("#")).forEach(s -> {
                String[] split;
                if (debug) {
                    System.out.println("_______ " + s);
                }
                if ((split = s.split("\t", 2)).length != 2) {
                    System.err.println("Invalid line: " + s);
                } else if (PATTERN.matcher(split[1]).matches() || split[0].contains("(?i)")) {
                    try {
                        this.regexp.put(Pattern.compile("(?m)^" + split[0] + "$"), split[1].replace("\"", "\\\""));
                    }
                    catch (PatternSyntaxException e2) {
                        System.err.println("PatternSyntaxException: " + split[0]);
                    }
                } else {
                    this.literal.put(split[0], split[1]);
                }
            });
            System.out.printf("init state: literal %d regex %d white %d \n", this.literal.size(), this.regexp.size(), white.size());
        }
        catch (Exception e) {
            System.err.println("Could not translate string");
            e.printStackTrace();
        }
    }

    private static void initWhiteList(InputStream is) {
        if (is == null) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            br.lines().distinct().filter(s -> !s.isEmpty() && !s.startsWith("#")).map(Pattern::compile).forEach(white::add);
        }
        catch (Exception e) {
            System.err.println("Could not add white string");
            e.printStackTrace();
        }
    }

    public static String translate(Object src, String lang, String str) throws Exception {
        if (str.contains("Are you sure")) {
            System.out.println("__________ " + src.toString() + str);
        }
        if (src instanceof PlainDocument && !src.getClass().equals(PlainDocument.class) || src instanceof JTextComponent && ((JTextComponent)src).isEditable() || src instanceof JTextArea || src instanceof DefaultStyledDocument && !src.getClass().getName().contains("DefaultStyledDocument") || src instanceof DefaultTreeCellRenderer || src instanceof DefaultTableCellRenderer && !src.getClass().getName().contains("DefaultTableCellHeaderRenderer") || src.getClass().equals(SynthComboBoxUI.class)) {
            if (debug) {
                System.out.println("~~~ filter input");
            }
            return str;
        }
        return Translator.translate(lang, str);
    }

    public static String translate(String lang, String str) throws Exception {
        if (str == null || str.length() < 2) {
            return str;
        }
        if (lang.contains("cn") && PATTERN_CHINESE.matcher(str).find()) {
            if (debug) {
                System.err.println("\t\tpatternChinese " + str);
            }
            return str;
        }
        String tranlated = whiteLru.get(str);
        if (tranlated != null) {
            return str;
        }
        tranlated = translateLru.get(str);
        if (tranlated != null) {
            return tranlated;
        }
        if (white.stream().anyMatch(pattern -> pattern.matcher(str).matches())) {
            if (debug) {
                CommonUtil.writeFile(FILE_WRITER_WHITE, str + "\t\n");
            }
            whiteLru.put(str, "");
            return str;
        }
        Translator translator = TRANSLATOR_MAP.get(lang);
        if (translator == null) {
            translator = new Translator(lang);
            TRANSLATOR_MAP.put(lang, translator);
        }
        if (Thread.currentThread().getName().contains("AWT-EventQueue")) {
            System.out.println("---------- " + str);
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                String s = stackTraceElement.toString();
                if (s.contains("leon406")) continue;
                if (s.contains("Hackvertor")) {
                    System.out.printf("&& %s\n", s);
                    if (PATTERN_BYPASS_PLUGIN.matcher(str).find()) {
                        return str;
                    }
                }
                if (!debug || s.contains("java.base") || s.contains("java.desktop") || s.contains("jdk.internal")) continue;
                System.out.println(s);
            }
        }
        StringBuilder sb = new StringBuilder();
        if (str.contains(" | ")) {
            System.out.println("filter translate");
            for (String str3 : str.split(" \\| ")) {
                if (sb.length() > 0) {
                    sb.append(" | ");
                }
                if (str3.contains("; ")) {
                    String[] split = str3.split(";  ");
                    for (int i = 0; i < split.length; ++i) {
                        if (i != 0) {
                            sb.append(";  ");
                        }
                        sb.append(translator.translate(split[i]));
                    }
                    continue;
                }
                sb.append(translator.translate(str3));
            }
        } else {
            for (String str3 : str.split("\n")) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(translator.translate(str3));
            }
        }
        String tr = sb.toString();
        if (debug) {
            CommonUtil.writeFile(FILE_WRITER_TRANSLATED, str + "===" + tr + "\n");
        }
        if (str.equals(tr)) {
            CommonUtil.writeFile(FILE_WRITER, str + "\t\n");
        }
        translateLru.put(str, tr);
        return tr;
    }

    public String translate(String str) {
        if (str == null || str.length() < 2) {
            return str;
        }
        String str2 = this.literal.get(str.trim());
        if (str2 == null) {
            str2 = str;
            for (Map.Entry<Pattern, String> entry : this.regexp.entrySet()) {
                Matcher matcher = entry.getKey().matcher(str2);
                if (!matcher.matches()) continue;
                str2 = matcher.replaceAll(entry.getValue());
            }
        }
        return str2;
    }

    static {
        white = new ArrayList<Pattern>(128);
        TRANSLATOR_MAP = new HashMap<String, Translator>(2);
        LOG_DIR = new File(CommonUtil.currentDir, "log");
        boolean bl = debug = Translator.class.getResource("/debug") != null;
        if (!debug) {
            debug = new File("debug").exists();
        }
        LOG_DIR.mkdirs();
        try {
            FILE_WRITER = new FileWriter(new File(LOG_DIR, "unTranslate.txt"), true);
            FILE_WRITER_WHITE = new FileWriter(new File(LOG_DIR, "whitelist.txt"), true);
            FILE_WRITER_TRANSLATED = new FileWriter(new File(LOG_DIR, "translated.txt"), true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("^^^^^^^  debug = " + debug);
        Translator.initWhiteList(Translator.class.getClassLoader().getResourceAsStream(WHITE_LIST_FILE));
        try {
            Translator.initWhiteList(new FileInputStream(WHITE_LIST_FILE));
        }
        catch (FileNotFoundException e) {
            System.err.println("Whitelist outer file not exits: white.txt");
        }
        whiteLru = new LruCache<String, String>(2048);
        translateLru = new LruCache<String, String>(8192);
    }
}

