/*
 * Decompiled with CFR 0.152.
 */
package leon406;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import leon406.util.CommonUtil;
import leon406.util.Keygen;
import leon406.util.SpringUtilities;
import leon406.util.TextFieldChangedListener;

public class KeygenDialog {
    private static final String TITLE = "Burp Suite Loader & Keygen & Hanzify - by Leon406 & Datch";
    public static final int WIDTH = 880;
    public static final int HEIGHT = 600;
    private JPanel root;
    private JTextField tfLicenseName;
    private JTextArea taLicense;
    private JTextArea taRequest;
    private JTextArea taResponse;
    private JTextField tfLoader;
    private JButton btnRun;

    private KeygenDialog() {
        this.setupUI();
        this.tfLicenseName.getDocument().addDocumentListener(new TextFieldChangedListener((e, type) -> {
            if (!this.tfLicenseName.getText().isEmpty()) {
                this.taLicense.setText(Keygen.generateLicense(this.tfLicenseName.getText()));
            }
        }));
        this.taRequest.getDocument().addDocumentListener(new TextFieldChangedListener((e, type) -> {
            if (!this.taRequest.getText().isEmpty()) {
                this.taResponse.setText(Keygen.generateActivation(this.taRequest.getText()));
            }
        }));
        this.btnRun.addActionListener(e -> CommonUtil.executeCmd(this.tfLoader.getText()));
        this.tfLicenseName.addPropertyChangeListener(evt -> this.taLicense.setText(Keygen.generateLicense(this.tfLicenseName.getText())));
    }

    private static void showKenGenDialog() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("setLookAndFeel " + e);
        }
        JFrame frame = new JFrame(TITLE);
        frame.setContentPane(new KeygenDialog().root);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
        frame.setLocationRelativeTo(null);
    }

    private void setupUI() {
        this.root = new JPanel(new SpringLayout());
        this.root.setPreferredSize(new Dimension(880, 600));
        this.root.setBorder(BorderFactory.createTitledBorder(null, TITLE, 2, 2));
        JLabel labelHint = new JLabel("Instructions:", 11);
        this.root.add(labelHint);
        JLabel labelInstruction = new JLabel("<html><body>1. Run Burp Suite Pro with the loader specified in the bootclasspath<br>2. Register using manual activation<br>3. On subsequent runs you must execute burpsuite with the loader otherwise it will become unregistered<body></html>");
        this.root.add(labelInstruction);
        JLabel labelCommand = new JLabel("Loader Command:", 11);
        this.root.add(labelCommand);
        JPanel commandOptions = new JPanel();
        this.root.add(commandOptions);
        this.tfLoader = new JTextField(CommonUtil.getLaunchCommand());
        this.tfLoader.setEditable(false);
        commandOptions.add(this.tfLoader);
        JCheckBox cbLoader = new JCheckBox("loader", null, CommonUtil.PREFERENCES.getBoolean("loader", false));
        cbLoader.addChangeListener(evt -> this.handleCheckBoxChange(evt.getSource(), "loader"));
        commandOptions.add(cbLoader);
        JCheckBox cbTranslateOnly = new JCheckBox("hanizfy", null, CommonUtil.PREFERENCES.getBoolean("hanizfy", true));
        cbTranslateOnly.addPropertyChangeListener(evt -> this.handleCheckBoxChange(evt.getSource(), "hanizfy"));
        commandOptions.add(cbTranslateOnly);
        JCheckBox cbAutoStart = new JCheckBox("auto start", null, CommonUtil.PREFERENCES.getBoolean("auto start", false));
        cbAutoStart.addPropertyChangeListener(evt -> this.handleCheckBoxChange(evt.getSource(), "auto start"));
        commandOptions.add(cbAutoStart);
        this.btnRun = new JButton("Run");
        this.btnRun.setEnabled(CommonUtil.hasBurpJar());
        commandOptions.add(this.btnRun);
        JLabel labelLicenseText = new JLabel("License Text: ", 11);
        this.root.add(labelLicenseText);
        this.tfLicenseName = new JTextField("licensed to Datch");
        this.tfLicenseName.setHorizontalAlignment(0);
        this.root.add(this.tfLicenseName);
        JPanel jpLic = new JPanel(new GridLayout(2, 1));
        JLabel labelLic = new JLabel("License: ", 11);
        JButton btnLic = new JButton("Copy");
        btnLic.addActionListener(e -> CommonUtil.copy(this.taLicense.getText()));
        jpLic.add(labelLic);
        jpLic.add(btnLic);
        this.root.add(jpLic);
        this.taLicense = new JTextArea(null, null, 5, 0);
        this.taLicense.setEditable(false);
        this.taLicense.setLineWrap(true);
        this.taLicense.setRows(5);
        JScrollPane licScrollPane = new JScrollPane(this.taLicense);
        this.root.add(licScrollPane);
        JPanel jpReq = new JPanel(new GridLayout(2, 1));
        JLabel labelReq = new JLabel("Activation Request: ", 11);
        jpReq.add(labelReq);
        JButton btnReq = new JButton("Paste");
        btnReq.addActionListener(e -> this.taRequest.setText(CommonUtil.pasteString()));
        jpReq.add(btnReq);
        this.root.add(jpReq);
        this.taRequest = new JTextArea(null, null, 5, 0);
        this.taRequest.setLineWrap(true);
        JScrollPane scrollPaneReq = new JScrollPane(this.taRequest);
        this.root.add(scrollPaneReq);
        JPanel jpRsp = new JPanel(new GridLayout(2, 1));
        JLabel labelRsp = new JLabel("Activation Response:", 11);
        JButton btnRsp = new JButton("Copy");
        btnRsp.addActionListener(e -> CommonUtil.copy(this.taResponse.getText()));
        jpRsp.add(labelRsp);
        jpRsp.add(btnRsp);
        this.root.add(jpRsp);
        this.taResponse = new JTextArea(null, null, 6, 0);
        this.taResponse.setLineWrap(true);
        JScrollPane scrollPane3 = new JScrollPane(this.taResponse);
        this.root.add(scrollPane3);
        SpringUtilities.makeCompactGrid(this.root, 6, 2, 6, 6, 6, 6);
    }

    private void handleCheckBoxChange(Object evt, String keyAutoStart) {
        JCheckBox checkBox = (JCheckBox)evt;
        CommonUtil.PREFERENCES.putBoolean(keyAutoStart, checkBox.isSelected());
        this.tfLoader.setText(CommonUtil.getLaunchCommand());
    }

    public static void main(String[] args) {
        boolean autoStart = CommonUtil.PREFERENCES.getBoolean("auto start", false);
        System.out.println("state " + autoStart + " args " + Arrays.toString(args));
        if (autoStart && args.length == 0) {
            CommonUtil.executeCmd(CommonUtil.getLaunchCommand());
        } else {
            KeygenDialog.showKenGenDialog();
        }
    }
}

