/*
 * Decompiled with CFR 0.152.
 */
package leon406;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import leon406.transformer.TranslateTransformer;

public class Agent {
    public static final String LOADER = "loader";
    public static final String BOTH = "loader,han";
    public static final String HAN = "han";

    public static void premain(String args, Instrumentation instrumentation) throws Exception {
        System.out.println("args " + args);
        if (args == null) {
            args = BOTH;
        }
        boolean useLoader = args.contains(LOADER);
        boolean useHanzify = args.contains(HAN);
        if (!useLoader && !useHanzify) {
            System.err.println("use none Transformers");
            return;
        }
        try {
            Class<?> transform = Class.forName("leon406.transformer.PatcherTransformer");
            if (useLoader) {
                System.out.println("use Loader Transformer");
                instrumentation.addTransformer((ClassFileTransformer)transform.newInstance());
            }
        }
        catch (Exception e) {
            System.err.println("PatcherTransformer not found");
        }
        if (useHanzify) {
            System.out.println("use Hanzify Transformer");
            instrumentation.addTransformer(new TranslateTransformer(), true);
        }
        for (Class cls : instrumentation.getAllLoadedClasses()) {
            if (!cls.getName().equals("java.lang.Class")) continue;
            instrumentation.retransformClasses(cls);
        }
    }
}

